

      SUBROUTINE xininter_1(q2minuse,q2maxuse,wwminuse,wwmaxuse,stat)
      IMPLICIT none
      INCLUDE 'com_xinter.inc'
      INTEGER*4 stat,npa,ind,ind_val,ind_mdiff,ind_mdiffmax,ind_mdiffmul
      INTEGER*4 i
      REAL*8    q2minuse,q2maxuse,wwminuse,wwmaxuse
      REAL*8    sigma,sigma_c2f,sigma_s2f,sigma_cf,sigma_sf,error
      CHARACTER*90 pathAMP,filemdiff
      CHARACTER*7  suf_qw
      CHARACTER*99 data_path
      COMMON/data_path/data_path


cc      pathAMP ='../data3/mdiff'
      pathAMP = data_path(1:index(data_path,' ')-1)//'/mdiff'

      npa=index(pathAMP,' ')-1
      Ebeam = 2.2d+0   

c --- BINS ---
      Ns12    =12
      Ns23    =12
      Ntheta  =6
      Npsi    =6


      NQQ2 = 9!11
      QQ2list( 1)=0.25
      QQ2list( 2)=0.45
      QQ2list( 3)=0.65
      QQ2list( 4)=0.95
      QQ2list( 5)=1.10
      QQ2list( 6)=1.30
      QQ2list( 7)=1.60
      QQ2list( 8)=1.90
      QQ2list( 9)=2.40
c      QQ2list(10)=3.00
c      QQ2list(11)=4.00
      Nq2_ini = 1
      Nq2_fin = NQQ2
cc      DO i=1,NQQ2
cc        if( QQ2list(i)       .lt.q2minuse ) Nq2_ini = i
cc        if( QQ2list(NQQ2-i+1).gt.q2maxuse ) Nq2_fin = NQQ2-i+1
cc      ENDDO

      NWW  = 34!11!34
      WWlist( 1)=1.2475
      WWlist( 2)=1.2625
      WWlist( 3)=1.2875
      WWlist( 4)=1.3125
      WWlist( 5)=1.3475
      WWlist( 6)=1.3625
      WWlist( 7)=1.3875
      WWlist( 8)=1.4125
      WWlist( 9)=1.4475
      WWlist(10)=1.4626
      WWlist(11)=1.4875
      WWlist(12)=1.5125
      WWlist(13)=1.5475
      WWlist(14)=1.5625
      WWlist(15)=1.5875
      WWlist(16)=1.6125
      WWlist(17)=1.6475
      WWlist(18)=1.6625
      WWlist(19)=1.6875
      WWlist(20)=1.7125
      WWlist(21)=1.7375
      WWlist(22)=1.7625
      WWlist(23)=1.7875
      WWlist(24)=1.8125
      WWlist(25)=1.8375
      WWlist(26)=1.8625
      WWlist(27)=1.8875
      WWlist(28)=1.9125
      WWlist(29)=1.9375
      WWlist(30)=1.9625
      WWlist(31)=1.9875
      WWlist(32)=2.0125
      WWlist(33)=2.0374
      WWlist(34)=2.0625
      Nww_ini = 1
      Nww_fin = NWW
cc      DO i=1,NWW
cc        if( WWlist(i)      .lt.wwminuse ) Nww_ini = i
cc        if( WWlist(NWW-i+1).gt.wwmaxuse ) Nww_fin = NWW-i+1
cc      ENDDO

      if(NQQ2.gt.NDQ2W.or.NWW.gt.NDQ2W)then
        print *,' !!! xininter_1: NQQ2.or.NWW.gt. STOP.=',NQQ2,NWW,NDQ2W
        stop
      endif


c----------------------------------------------------------------------
c     Read 5diff cross-section
c----------------------------------------------------------------------
      ind_mdiffmul = NQQ2*NWW*ns12*ns23*ntheta*npsi
      ind_mdiffmax = 0
       print *,' Nqq2,Nww=',NQQ2,NWW
       print *,' NNq2_ini/fin,QQ=',Nq2_ini,Nq2_fin,Q2minuse,Q2maxuse
       print *,' NNww_ini/fin,WW=',Nww_ini,Nww_fin,WWminuse,WWmaxuse
       print *,' ns12,ns23,ntheta,npsi=',ns12,ns23,ntheta,npsi
       print *,' ind_mdiffmul=',ind_mdiffmul
      DO iqq2=Nq2_ini,Nq2_fin
      DO iww =Nww_ini,Nww_fin
        qq2 = QQ2list(iqq2)
        ww  = WWlist(iww)
        CALL QWSUFFIX(qq2,ww,suf_qw)
        filemdiff = pathAMP(1:npa)//'/x_'//suf_qw//'_dmdiff.dat'
        write(*,721) qq2,ww
 721    format('Reading cross-section  Q2=',f6.2,'  W=',f8.4)
        open(unit=10,file=filemdiff,status='OLD')
        ind_val = (npsi+ntheta+ns23+ns12) * ((Iqq2-1)*Nww + Iww - 1)
        if(ind_val+npsi+ntheta+ns23+ns12.gt.NDmdiff_vall)then
          print *,' !!! xininter_1: .gt.NDmdiff_vall STOP.'
          stop
        endif
        DO is23=1,ns23
        DO is12=1,ns12
        DO itheta=1,ntheta          
        DO ipsi=1,npsi

          read(10,*) s12,s23,theta,phi,psi,
     &               sigma,sigma_c2f,sigma_s2f,sigma_cf,sigma_sf,error

          ind = ind_mdiff(IQQ2,IWW,is12,is23,itheta,ipsi)
          if(ind.gt.ind_mdiffmax) ind_mdiffmax=ind
          X_mdiff(ind)     = sigma
          X_c2f_mdiff(ind) = sigma_c2f
          X_s2f_mdiff(ind) = sigma_s2f
          X_cf_mdiff(ind)  = sigma_cf
          X_sf_mdiff(ind)  = sigma_sf
          Vall_mdiff( ind_val+ 0                + ipsi)   = psi
          Vall_mdiff( ind_val+ npsi             + itheta) = theta
          Vall_mdiff( ind_val+ npsi+ntheta      + is23)   = s23
          Vall_mdiff( ind_val+ npsi+ntheta+ns23 + is12)   = s12

c          if(abs(qq2-0.65).lt.0.02 .and. abs(ww-1.45).lt.0.01 .and.
c     &       abs(s12-0.17686).lt.0.01 .and. 
c     &       abs(s23-1.21165).lt.0.01 .and. 
c     &       abs(theta-0.01000).lt.0.01    .and.
c     &       abs(psi-2.51527).lt.0.01      )then
c            print *,' TTT iqq2,iww,qq2,ww=',iqq2,iww,qq2,ww
c            print *,' TTT ind,ind_val=',ind,ind_val
c            print *,' TTT is12,is23,itheta,ipsi=',is12,is23,itheta,ipsi
c            print *,' TTT s12,s23,theta,psi=',s12,s23,theta,psi
c            print *,' TTT XXXX=',X_mdiff(ind),X_c2f_mdiff(ind),X_s2f_mdiff(ind),X_cf_mdiff(ind),X_sf_mdiff(ind)
c          endif
          
        ENDDO
        ENDDO
        ENDDO
        ENDDO

        NA_mdiff(1) = Npsi
        NA_mdiff(2) = Ntheta
        NA_mdiff(3) = Ns23
        NA_mdiff(4) = Ns12

        As12min(iqq2,iww)  =Vall_mdiff(ind_val+ npsi+ntheta+ns23+ 1)
        As12max(iqq2,iww)  =Vall_mdiff(ind_val+ npsi+ntheta+ns23+ ns12)
        As23min(iqq2,iww)  =Vall_mdiff(ind_val+ npsi+ntheta     + 1)
        As23max(iqq2,iww)  =Vall_mdiff(ind_val+ npsi+ntheta     + ns23)
        Athetamin(iqq2,iww)=Vall_mdiff(ind_val+ npsi            + 1)
        Athetamax(iqq2,iww)=Vall_mdiff(ind_val+ npsi            + ntheta)
        Apsimin(iqq2,iww)  =Vall_mdiff(ind_val+ 0               + 1)
        Apsimax(iqq2,iww)  =Vall_mdiff(ind_val+ 0               + npsi)  

        close(10)
      ENDDO
      ENDDO 

      write(*,791) ind_mdiffmax,ind_mdiffmul
 791  format(' --- XININTER_1 done. Ind Max/Mul =',i9,' /',i9)
      RETURN
      END   




      SUBROUTINE xsecinter_1(QQ2_ii,WW_ii,s12_i,s23_i,theta_i,phi_i,psi_i,
     &                       Xsec)
      IMPLICIT none
     
           
      INCLUDE 'com_xinter.inc'
c      include 'binning.inc' 
      

      REAL*8    QQ2_ii,WW_ii
      REAL*8    QQ2_i,WW_i,s12_i,s23_i,theta_i,phi_i,psi_i,xsec
      REAL*8    dqq2,dww,X, Factor, smpipi,smprpi, CorrFact
      INTEGER*4 ind,Nnearqq2,Nnearww,  i ,myindex
      REAL*8    dcostheta
      REAL*8    pii,pigr,cdr
      INTEGER*4 iqq2min,iqq2max,iwwmin,iwwmax
      REAL*4    FINT
      integer   binpippim, bpippim,bprpim,binprpim,binW,binQ2,bprpip
      integer   GetbinW,GetbinQ2,binprpip
      real*8    prpim,m_pion,m_pr
      real*8    getcorrfact
      parameter (m_pion=0.13957,m_pr=0.938272)
      
      CorrFact = 1.0
      smpipi = sqrt(S12_i)
      smprpi = sqrt(S23_i)

c      binW    = GetbinW(sngl(WW_ii))
c      binQ2   = GetbinQ2(sngl(QQ2_ii))
c      bpippim =binpippim(sngl(smpipi))
c      bprpip  =binprpip(sngl(smprpi))
c      if(binW .gt.bin_W)  binW  = bin_W
c      if(binQ2.gt.bin_Q2) binQ2 = bin_W
c      if(bpippim.ge.0.and.bpippim.lt.bin_pippim .and.
c     &   binQ2.ge.0.and.binQ2.lt.bin_Q2 .and.
c     &   binW.ge.0.and.binW.lt.bin_W .and.
c     &   bprpip.ge.0.and.bprpip.lt.bin_prpip)
c     & CorrFact=
c     & CorrFact*dble(getfactor(binW,binQ2,bpippim,bprpip))
c       if(CorrFact.eq.0.) CorrFact = 1.d+0   
      
      CorrFact = 1.d+0           
      	
      
      CorrFact = getcorrfact(QQ2_ii,WW_ii,smpipi,smprpi)


      pii = acos(-1.d+0)
      pigr= pii
      cdr = 180./pii
      QQ2_i = abs(QQ2_ii)
      WW_i   = WW_ii
      Factor = 1.0
      if(WW_ii.lt.1.2)then
         WW_i    = 1.2
         Factor = Factor*0.0
      endif
      if(WW_ii.gt.2.0625)then
         WW_i    = 2.0625
         Factor = Factor
      endif
      if(abs(QQ2_ii).gt.2.00)then
         QQ2_i    = 2.00
         Factor = Factor * ( (1.+abs(QQ2_ii)/0.7)**(-2) )
         Factor = Factor / ( (1.+      2.00 /0.7)**(-2) )
      endif

c-----------------------------------------------------------------------
c       Determine nearest Q2-, W-bins 
c-----------------------------------------------------------------------

      dqq2=3.0
      dww =2.0 
      IF( qq2_i.lt.(qq2list(1)   -dqq2) .or.
     &    qq2_i.gt.(qq2list(Nqq2)+dqq2) .or.
     &    ww_i.lt. (wwlist(1)    -dww)  .or.
     &    ww_i.gt. (wwlist(Nww)  +dww)       )THEN
        print *,' xsecinter_1: Q2 or W is out of range (1)'
        print *,' xsecinter_1: Q2=',qq2_i,'  Q2min/max=',qq2list(1),qq2list(Nqq2)
        print *,' xsecinter_1: W =',ww_i, '  Wmin/max =',wwlist(1),wwlist(Nww)
        stop
      ENDIF
      IF( qq2_i.lt.(qq2list(Nq2_ini)-dqq2) .or.
     &    qq2_i.gt.(qq2list(Nq2_fin)+dqq2) .or.
     &    ww_i.lt. (wwlist(Nww_ini) -dww)  .or.
     &    ww_i.gt. (wwlist(Nww_fin) +dww)       )THEN
        print *,' xsecinter_1: Q2 or W is out of range (2)'
        print *,' xsecinter_1: Q2,Nq2_i/f=',Nq2_ini,Nq2_fin
        print *,' xsecinter_1: W, Nww_i/f=',Nww_ini,Nww_fin
        stop
      ENDIF

      IF(qq2_i.le.qq2list(1))THEN
        iqq2min=1
        iqq2max=2
      ELSEIF(qq2_i.ge.qq2list(Nqq2))THEN
        iqq2min=Nqq2-1
        iqq2max=Nqq2
      ELSE
        do i=1,Nqq2-1
        if(qq2_i.ge.qq2list(i).and.qq2_i.le.qq2list(i+1))then
        iqq2min=i
        iqq2max=i+1
        endif
        enddo
      ENDIF

      IF(ww_i.le.wwlist(1))THEN
        iwwmin=1
        iwwmax=2
      ELSEIF(ww_i.ge.wwlist(Nww))THEN
        iwwmin=Nww-1
        iwwmax=Nww
      ELSE
        do i=1,Nww-1
        if(ww_i.ge.wwlist(i).and.ww_i.le.wwlist(i+1))then
        iwwmin=i
        iwwmax=i+1
        endif
        enddo
      ENDIF

c      print *,' iqq2min,max=',iqq2min,iqq2max,'   Nqq2=',Nqq2
c      print *,' qq2_i=',qq2_i,' qmin,max=', qq2list(iqq2min),qq2list(iqq2max)
   

c-----------------------------------------------------------------------
c       Interpolate Cross section in 4dim at nearest Q2-, W-bins 
c-----------------------------------------------------------------------
      Nnearqq2=iqq2max-iqq2min+1
      Nnearww =iwwmax-iwwmin+1
      if(Nnearqq2.gt.NDiqw.or.Nnearww.gt.NDiqw)then
        print *,' ! xsecinter_1: NDiqw,nqq2,nww==',NDiqw,Nnearqq2,Nnearww
        stop 
      endif
      if((Nnearqq2)*(Nnearww).gt.NDiqw)then
        print *,' ! xsecinter_1 .gt.NDiqw. STOP.'
      endif
      if((Nnearqq2)+(Nnearww).gt.1000)then
        print *,' ! xsecinter_1 .gt.1000 STOP.'
      endif
      DO iqq2=iqq2min,iqq2max
      DO iww =iwwmin, iwwmax

        CALL XINTER1(iqq2,iww,s12_i,s23_i,theta_i,phi_i,psi_i,X)
        if(X.lt.0.d+0) X = 0.d+0

        Vall_iqw( 0       + iww-iwwmin+1 )   = WWlist(iww)
        Vall_iqw( Nnearww + iqq2-iqq2min+1 ) = QQ2list(iqq2)
        ind = ((iqq2-iqq2min+1)-1)*Nnearww + (iww-iwwmin+1)
        X_iqw(ind) = X

c        print *,' XXX Qi,Wi,Q,W,X==',QQ2_i,WW_i,QQ2list(iqq2),WWlist(iww),X_iqw(ind)

      ENDDO
      ENDDO
      NA_iqw(1) = Nnearww
      NA_iqw(2) = Nnearqq2
      

c-----------------------------------------------------------------------
c       Interpolate in Q2-, W-bins
c-----------------------------------------------------------------------
      
      Vint_iqw(1) = WW_i
      Vint_iqw(2) = QQ2_i

      Xsec = FINT(2,Vint_iqw,NA_iqw,Vall_iqw,X_iqw)
      if(Xsec.lt.0.d+0)  Xsec = 0.
      Xsec = Xsec*Factor
      Xsec = Xsec*CorrFact

c NEWNEW
      Xsec = Xsec*sin(theta_i)

c      print *,' XXX interp QW =',Xsec

      RETURN
      END




c-----------------------------------------------------------------------
c                  IND_MDIFF
c-----------------------------------------------------------------------
      FUNCTION ind_mdiff(IQQ1,IWW1,is121,is231,itheta1,ipsi1)
      IMPLICIT none
      INTEGER  ind_mdiff,IQQ1,IWW1,is121,is231,itheta1,ipsi1 
      INCLUDE 'com_xinter.inc'
      ind_mdiff = (IQQ1-1)*Nww*Ns12*Ns23*Ntheta*Npsi +
     &            (IWW1-1)*Ns12*Ns23*Ntheta*Npsi +
     &            (is121-1)*Ns23*Ntheta*Npsi +
     &            (is231-1)*Ntheta*Npsi +
     &            (itheta1-1)*Npsi + 
     &            (ipsi1)
      if(ind_mdiff.gt.NDmdiff_full)then
        print *,' ind_mdiff: ind.gt.max=',ind_mdiff,NDmdiff_full
        print *,' !!!STOP!!!'
        stop
      endif
      RETURN
      END   




c-----------------------------------------------------------------------
c                  XINTER1
c-----------------------------------------------------------------------
      SUBROUTINE XINTER1(iq2,iw,s12x,s23x,theta1x,phi1x,psi1x, Xsec)
      IMPLICIT none
      INCLUDE 'com_xinter.inc'
      INTEGER*4 iq2,iw,ind,ind_val,i
      REAL*8 s12x,s23x,theta1x,phi1x,psi1x, Xsec,pigr
      REAL*8 m1,m2,m3,wwthis
      REAL*4 FINT
      INTEGER ind_mdiff

      m1 = 0.13956995d+0
      m2 = 0.13956995d+0
      m3 = 0.93827231d+0
      pigr = acos(-1.d+0)
      wwthis = WWlist(iw)
      Xsec    = 0.d+0
      s12min  =As12min(iqq2,iww)
      s12max  =As12max(iqq2,iww)
      s23min  =As23min(iqq2,iww)
      s23max  =As23max(iqq2,iww)
     
c      print *,' ss12minmax=',s12min,s12max
c      print *,' ss23minmax=',s23min,s23max
c      print *,' ss12minmax=',(m1+m2)**2,(WW-m3)**2
c      print *,' ss23minmax=',(m2+m3)**2,(WW-m1)**2

      thetamin=Athetamin(iqq2,iww)
      thetamax=Athetamax(iqq2,iww)
      psimin  =Apsimin(iqq2,iww)
      psimax  =Apsimax(iqq2,iww)      
 
c        print *,' III iq2,iw=',iq2,iw
c        print *,' III s12x,s23x,theta1x,phi1x,psi1x=',s12x,s23x,theta1x,phi1x,psi1x
c        print *,' III s12min,s12max    =',s12min,s12max
c        print *,' III s23min,s23max    =',s23min,s23max
c        print *,' III thetamin,thetamax=',thetamin,thetamax
c        print *,' III psimin,psimax=',psimin,psimax

      if( Wwthis .lt.m1+m2+m3 )   RETURN
      if( s12x.lt.s12min.or.s12x.gt.s12max )   RETURN
      if( s23x.lt.s23min.or.s23x.gt.s23max )   RETURN
      if( theta1x.gt.pigr .or.theta1x.lt.0.)   RETURN
      if( psi1x.gt.2.*pigr .or. psi1x.lt.0.0)  RETURN
      Vint_mdiff(1)=psi1x
      Vint_mdiff(2)=theta1x
      Vint_mdiff(3)=s23x 
      Vint_mdiff(4)=s12x
      ind = ind_mdiff(IQ2,IW,1,1,1,1)
      ind_val = (npsi+ntheta+ns23+ns12) * ((Iqq2-1)*Nww + Iww - 1)

c      print *,' III ind,ind_val,=',ind,ind_val
c      print *,' III Vint_mdiff=',(Vint_mdiff(i),i=1,4)
c      print *,' III NA_mdiff=',(NA_mdiff(i),i=1,4)
c      print *,' III Vall_mdiff=',(Vall_mdiff(ind_val+i),i=1,12+12+12)
c      print *,' III XX ',FINT(4,Vint_mdiff,NA_mdiff,Vall_mdiff(ind_val+1),X_mdiff(ind))
c      print *,' III XX ',FINT(4,Vint_mdiff,NA_mdiff,Vall_mdiff(ind_val+1),X_c2f_mdiff(ind))
c      print *,' III XX ',FINT(4,Vint_mdiff,NA_mdiff,Vall_mdiff(ind_val+1),X_s2f_mdiff(ind))
c      print *,' III XX ',FINT(4,Vint_mdiff,NA_mdiff,Vall_mdiff(ind_val+1),X_cf_mdiff(ind))
c      print *,' III XX ',FINT(4,Vint_mdiff,NA_mdiff,Vall_mdiff(ind_val+1),X_sf_mdiff(ind))

      Xsec = 
     &  FINT(4,Vint_mdiff,NA_mdiff,Vall_mdiff(ind_val+1),X_mdiff(ind))
     & +FINT(4,Vint_mdiff,NA_mdiff,Vall_mdiff(ind_val+1),X_c2f_mdiff(ind))*cos(2.*phi1x)
     & +FINT(4,Vint_mdiff,NA_mdiff,Vall_mdiff(ind_val+1),X_s2f_mdiff(ind))*sin(2.*phi1x)
     & +FINT(4,Vint_mdiff,NA_mdiff,Vall_mdiff(ind_val+1),X_cf_mdiff(ind))*cos(phi1x)
     & +FINT(4,Vint_mdiff,NA_mdiff,Vall_mdiff(ind_val+1),X_sf_mdiff(ind))*sin(phi1x)
    
 
c      if(iq2.eq.4.and.iw.eq.3) then
c      print *,'iq2,iw,s12x,s23x,theta1x,phi1x,psi1x, Xsec ='
c      print *, iq2,iw,s12x,s23x,theta1x,phi1x,psi1x, Xsec
c      open(22,file='ss4_iissaa.dat')
c      write(22,*) 'ISX',iq2,iw,s12x,s23x,theta1x,phi1x,psi1x, Xsec
c      close(22)
c      open(22,file='ss4_indvint.dat')
c      write(22,*) 'IND=',ind_val,ind,' VINT=',Vint_mdiff
c      close(22)
c      open(22,file='ss4_val.dat')
c      write(22,*) (Vall_mdiff(ind_val+i),i=1,ns12+ns23+ntheta+npsi)
c      close(22)
c      open(22,file='ss4_x.dat')
c      write(22,*) (X_mdiff(ind-1+i),i=1,ns12*ns23*ntheta*npsi)
c      close(22)
c      stop
c      endif

 
      RETURN
      END




c-----------------------------------------------------------------------
c                  QWSUFFIX
c-----------------------------------------------------------------------
      SUBROUTINE QWSUFFIX(qq2,ww,suf)
      IMPLICIT none
      REAL*8 qq2,ww
      INTEGER*4 ind
      CHARACTER*3 ch3q2,ch3w
      CHARACTER*7 ch7,suf
      
      write(ch3q2,"(i3)") nint(abs(qq2)*100)
      write(ch3w,"(i3)")  nint(ww*100)
      ind=index(ch3q2,' ')
      if(ind.gt.0) ch3q2(ind:ind)='0'
      ind=index(ch3q2,' ')
      if(ind.gt.0) ch3q2(ind:ind)='0'
      ind=index(ch3w,' ')
      if(ind.gt.0) ch3w(ind:ind)='0'
      ind=index(ch3w,' ')
      if(ind.gt.0) ch3w(ind:ind)='0'
      ch7 = ch3q2//'_'//ch3w

      suf = ch7

      RETURN
      END




c-----------------------------------------------------------------------
c                  DTRAPER1
c-----------------------------------------------------------------------
c
c   Changed for REAL*8
c
      SUBROUTINE DTRAPER1 (X,Y,E,N,AA,BB,RE,SD)
      IMPLICIT REAL*8 (A-H,O-Z)
      IMPLICIT INTEGER*4 (I-N)
      DIMENSION X(N),Y(N),E(N)
      RE=0.D+0
      SD=0.D+0
      IF(AA .EQ. BB .OR. N .LT. 2) RETURN
      A=AA
      B=BB
      IF(AA .LT. BB) GO TO 1
      A=BB
      B=AA
    1 DO 40 I1 = 2,N
      I=I1
      IF(X(I) .GE. A) GO TO 41
   40 CONTINUE
   41 DO 42 J1 = 2,N
      J=J1
      IF(X(J) .GE. B) GO TO 43
   42 CONTINUE
   43 WI1=(X(I)-A)**2/(X(I)-X(I-1))
      WI=(1.0+(A-X(I-1))/(X(I)-X(I-1)))*(X(I)-A)
      WJ1=(1.0+(X(J)-B)/(X(J)-X(J-1)))*(B-X(J-1))
      WJ=(B-X(J-1))**2/(X(J)-X(J-1))
      IF(I .NE. J) GO TO 2
      WI1=WI1+WJ1+X(I-1)-X(I)
      WI=WI+WJ+X(I-1)-X(I)
      WJ1=0.D+0
      WJ=0.D+0
      GO TO 10
    2 IF(I .NE. J-1) GO TO 3
      WI=WI+WJ1
      WJ1=0.D+0
      GO TO 10
    3 WI=WI+X(I+1)-X(I)
      WJ1=WJ1+X(J-1)-X(J-2)
      IF(I .EQ. J-2) GO TO 10
      LI=I+1
      LJ=J-2
      DO 4 L = LI,LJ
      RE=RE+(X(L+1)-X(L-1))*Y(L)
    4 SD=SD+((X(L+1)-X(L-1))*E(L))**2
   10 RE=RE+WI1*Y(I-1)+WI*Y(I)+WJ1*Y(J-1)+WJ*Y(J)
      SD=SD+(WI1*E(I-1))**2+(WI*E(I))**2+(WJ1*E(J-1))**2+(WJ*E(J))**2
      RE=0.5*RE
      SD=0.5*SQRT(SD)
      IF(AA .GT. BB) RE=-RE
      RETURN
      END
