

c
c List of the subroutines in this file:
c
c   KINEMA3, KINEMA3ALLOW_S12s23, KINEMA3_REDALL, KINEMA3_GETPSI
c


c======================================================================
c============================KINEMA3===================================

c----------------------------------------------------------------------
c  This subroutine
c  for the process:
c           a(Gamma_virtual) + b(Nucl) -> 1(pi-) + 2(pi+) + 3(Delta)
c           (in CMS, Z-axes is along the Photon(a))
c  calculates:
c    4-momenta of the particles
c  starting from:
c    pa2,ww,s12,s23,teta1,fi1,fi
c
c  pa2     - (4-vector_of_Pa)**2                           -- input
c  ww      - (pa+pb)                                       -- input
c  pa(0:6) - 4-momentum of a-particle and angles           -- output
c  pb(0:6) - 4-momentum of b-particle and angles           -- output
c  p1(0:6) - 4-momentum of 1-particle and angles           -- output
c  p2(0:6) - 4-momentum of 2-particle and angles           -- output
c  p3(0:6) - 4-momentum of 3-particle and angles           -- output
c  (pa,pb,p1,p2,p3 arrays of the type p(0:6))
c  ma,mb,m1,m2,m3 - masses (ma is not used, since
c                   pa2 is to be determined)               -- input
c  s12 - (p1+p2)**2                                        -- input
c  s23 - (p2+p3)**2                                        -- input
c  teta1,fi1 - angles of the 1-particle (in CMS)           -- input
c  fi23 - angle between (p2,p3)-plane and (pa,pb,p1)-plane;
c         fi23=0 if 2-part. is on the the side of a-part.;
c         rotation axes is determined by the p2 direction  -- input 
c  ncheck - (0 - check the calculated P, 1 - don't check)  -- input  
c  nc - exit code  0 - OK                                  -- output
c                  1 - the process is kinematically banned
c                  2 - a-particle's monenta is not 
c                      along the Z-axes
c
c  All real parameters are of the REAL*8 type
c----------------------------------------------------------------------

      SUBROUTINE kinema3(pa,pb,p1,p2,p3,ma,mb,m1,m2,m3,
     &                   pa2,ww,s12,s23,teta1,fi1,fi23, ncheck,nc)
      IMPLICIT none

      REAL*8 pa2,ww,s12,s23
      REAL*8 pa(0:6),pb(0:6)
      REAL*8 p1  (0:6),p2  (0:6),p3  (0:6),p1_m,  p2_m,  p3_m
      REAL*8 p1_1(0:6),p2_1(0:6),p3_1(0:6),p1_1_m,p2_1_m,p3_1_m
      REAL*8 TH1,PH1, TH2,PH2, TH3,PH3
      REAL*8 ma,mb,m1,m2,m3,teta1,fi1,fi23,m1_2,m2_2,m3_2
      REAL*8 p_tmp,teta_tmp,fi_tmp, mprot
      INTEGER*4 nc,ncheck
      REAL*8 zero,quasizero,quasizero2,pii, s,s31,x,y,z,u,v,w, g
      REAL*8 mu(3),p1_nrm(3),p2_nrm(3),alfa(3),beta(3),abv(3)
      REAL*8 mup1,p1p2,a,b
      
      REAL*8 G_BYCKLING
      DATA   mprot/0.93827231/
 
      

c----------------------------------------------------
c     Define G-function of Byckling,  Byckling, p.89 
c----------------------------------------------------

      G_BYCKLING(x,y,z,u,v,w) =
     &   (x**2)*y+x*(y**2) + (z**2)*u+z*(u**2) + (v**2)*w+v*(w**2)
     &   + x*z*w + x*u*v + y*z*v + y*u*w
     &   - x*y*(z+u+v+w) - z*u*(x+y+v+w) - v*w*(x+y+z+u)


      zero=0.0d+0
      pii = acos(-1.d+0)
      nc=0

      s = ww**2
      s31 = s - s12 - s23 + m1**2 + m2**2 + m3**2

      m1_2=m1**2
      m2_2=m2**2
      m3_2=m3**2

c-------------------------------------------------------
c     Check wether the process is kinematically allowed
c-------------------------------------------------------

      IF(pa(1).ne.zero.or.pa(2).ne.zero) THEN
        nc=2
        RETURN
      ENDIF
       
      G = G_BYCKLING(s12,s23,s,m2_2,m1_2,m3_2)
      IF(G.gt.zero) THEN
        nc=1
        RETURN
      ENDIF


c------------------------------------------------
c     Momenta of the a- and b- initial particles
c------------------------------------------------
      pa(0) = (ww**2+pa2-mprot**2)/2./ww
      pa(1)=0.d+0
      pa(2)=0.d+0
      pa(3)=sqrt(pa(0)**2-pa2)
      
      pb(0)=sqrt(mprot**2+pa(3)**2)
      pb(1)=0.d+0
      pb(2)=0.d+0
      pb(3)=-pa(3)
      
c      Type *,'a and b particle evaluation PIZDEC'
c      type *,s,m1_2,m2_2,m3_2,s12,s23,s31,ww

c----------------------------------------------------------------------
c     Kinematics of the outgoing particles 
c----------------------------------------------------------------------

c----------------------------------------
c     Moduli of the momenta and energies
c----------------------------------------
      p1(0) = (s+m1_2-s23)/2./ww
      p2(0) = (s+m2_2-s31)/2./ww
      p3(0) = (s+m3_2-s12)/2./ww
      IF( p1(0).lt.0.d+0 .or. p1(0)**2-m1_2.lt.0.d+0 .or.
     &    p2(0).lt.0.d+0 .or. p2(0)**2-m2_2.lt.0.d+0 .or.
     &    p3(0).lt.0.d+0 .or. p3(0)**2-m3_2.lt.0.d+0      ) THEN
        nc=1
        RETURN
      ENDIF
      p1_m = sqrt(p1(0)**2-m1_2)
      p2_m = sqrt(p2(0)**2-m2_2)
      p3_m = sqrt(p3(0)**2-m3_2)


c        Type *,'1 2 3 particle momenta muduls evaluation PIZDEC'      
c------------------------------------------------------------------
c     Angles and three momenta of the particles in the frame 
c     with the Z-axes along the p1, X-axes perp. to the Z situated
c     on the a-b-1-plane
c------------------------------------------------------------------

c--------------------------------------------
c     Angles of the 1-particle relative to z
c--------------------------------------------
      TH1 = 0.d+0
      PH1 = 0.d+0
     
c--------------------------------------------
c     Angles of the 2-particle relative to z
c--------------------------------------------
      a = ((m1_2+m2_2 + 2.*p1(0)*p2(0) - s12)/2./p1_m/p2_m)
      TH2 = acos(a)
      PH2 = fi23

C--------------------------------------------
C     Angles of the 3-particle relative to z
C--------------------------------------------
      a = ((m1_2+m3_2 + 2.*p1(0)*p3(0) - s31)/2./p1_m/p3_m)
      TH3 = acos(a)
      PH3 = fi23 + pii
      IF(PH3 .gt. 2.*pii) PH3 = PH3 - 2.*pii

c------------------------------------
c     Three momenta of the particles 
c------------------------------------

      p1(1) = 0.0
      p1(2) = 0.0
      p1(3) = p1_m

      p2(1) = p2_m*SIN(TH2)*COS(PH2)
      p2(2) = p2_m*SIN(TH2)*SIN(PH2)
      p2(3) = p2_m*COS(TH2)

      p3(1) = p3_m*SIN(TH3)*COS(PH3)
      p3(2) = p3_m*SIN(TH3)*SIN(PH3)
      p3(3) = p3_m*COS(TH3)
      

c----------------------------------------------------------------------
c     Rotation to the hadronic CMS 
c     (z axis along q vector but x axis is still on the hadronic plane)
c----------------------------------------------------------------------

      p1_1(1) =  COS(teta1)*p1(1) + SIN(teta1)*p1(3)
      p1_1(2) =  p1(2)
      p1_1(3) =-(SIN(teta1)*p1(1)) + COS(teta1)*p1(3)
      p1_1(0) = p1(0)
      p1_1_m  = p1_m

      p2_1(1) =  COS(teta1)*p2(1) + SIN(teta1)*p2(3)
      p2_1(2) =  p2(2)
      p2_1(3) =-(SIN(teta1)*p2(1)) + COS(teta1)*p2(3)
      p2_1(0) = p2(0)
      p2_1_m  = p2_m

      p3_1(1) = - p1_1(1) - p2_1(1)
      p3_1(2) = - p1_1(2) - p2_1(2)
      p3_1(3) = - p1_1(3) - p2_1(3)
      p3_1(0) = p3(0)
      p3_1_m  = p3_m

c----------------------------------------------------------
c     Rotation to the LAB plane (z axis is still along the 
c     virtual photon but x axis on the ee' plane)
c----------------------------------------------------------

      p1(1) = COS(fi1)*p1_1(1) - SIN(fi1)*p1_1(2)
      p1(2) = SIN(fi1)*p1_1(1) + COS(fi1)*p1_1(2)
      p1(3) = p1_1(3)
      p1(0) = p1_1(0)
      p1_m  = p1_1_m

      p2(1) = COS(fi1)*p2_1(1) - SIN(fi1)*p2_1(2)
      p2(2) = SIN(fi1)*p2_1(1) + COS(fi1)*p2_1(2)
      p2(3) = p2_1(3)
      p2(0) = p2_1(0)
      p2_m  = p2_1_m 

      p3(1) = - p1(1) - p2(1)
      p3(2) = - p1(2) - p2(2)
      p3(3) = - p1(3) - p2(3)
      p3(0) = p3_1(0)
      p3_m  = p3_1_m 

c---------------------------------------------------------
c     Save modulus, teta and fi for the particles as well 
c---------------------------------------------------------

      CALL ppp2tetafi(pa(1),pa(2),pa(3), pa(4),pa(5),pa(6))
      CALL ppp2tetafi(pb(1),pb(2),pb(3), pb(4),pb(5),pb(6))
      CALL ppp2tetafi(p1(1),p1(2),p1(3), p1(4),p1(5),p1(6))
      CALL ppp2tetafi(p2(1),p2(2),p2(3), p2(4),p2(5),p2(6))
      CALL ppp2tetafi(p3(1),p3(2),p3(3), p3(4),p3(5),p3(6))

c      pa(4)=pa(4)
c      pa(5)=zero
c      pa(6)=zero 
c      pb(4)=pb(4)
c      pb(5)=pii
c      pb(6)=pii
      

c--------------------------------------------------
c     Check for Kinematics 
c--------------------------------------------------

      IF(ncheck.eq.0) THEN

c ----- 3-momentum conservation: 3vectorPinitial=0=3vectorPfinal=0 -----

      quasizero=(abs(pa(0))+abs(pb(0)))*1.d-10
      quasizero2=0.01
      IF(abs(pa(1)+pb(1)).gt.quasizero .or.
     &   abs(pa(2)+pb(2)).gt.quasizero .or.
     &   abs(pa(3)+pb(3)).gt.quasizero .or.
     &   abs(p1(1)+p2(1)+p3(1)).gt.quasizero .or.
     &   abs(p1(2)+p2(2)+p3(2)).gt.quasizero .or.
     &   abs(p1(3)+p2(3)+p3(3)).gt.quasizero .or.
     &   abs(p1(0)**2-p1(1)**2-p1(2)**2-p1(3)**2-m1**2).gt.quasizero.or.
     &   abs(p2(0)**2-p2(1)**2-p2(2)**2-p2(3)**2-m2**2).gt.quasizero.or.
     &   abs(p3(0)**2-p3(1)**2-p3(2)**2-p3(3)**2-m3**2).gt.quasizero
     &  ) THEN
        print *,' ...sub. KINEMA3 kinematics is bad'
        print *,' pa(1)+pb(1)=',pa(1)+pb(1)
        print *,' pa(2)+pb(2)=',pa(2)+pb(2)
        print *,' pa(3)+pb(3)=',pa(3)+pb(3)
        print *,' p1(1)+p2(1)+p3(1)=',p1(1)+p2(1)+p3(1)
        print *,' p1(2)+p2(2)+p3(2)=',p1(2)+p2(2)+p3(2)
        print *,' p1(3)+p2(3)+p3(3)=',p1(3)+p2(3)+p3(3)
        print *,' m1,3v_p1**2=',m1,p1(1)**2+p1(2)**2+p1(3)**2
        print *,' m2,3v_p2**2=',m2,p2(1)**2+p2(2)**2+p2(3)**2
        print *,' m3,3v_p3**2=',m3,p3(1)**2+p3(2)**2+p3(3)**2
        STOP
      ENDIF

c ----- Energie conservation: Einitial=Efinal=ww -----

      IF(abs(pa(0)+pb(0)-ww).gt.quasizero .or.
     &   abs(p1(0)+p2(0)+p3(0)-ww).gt.quasizero ) THEN
        print *,' ...sub. KINEMA3 kinematics is bad'
        print *,' ww=',ww
        print *,' pa(0)+pb(0)=',pa(0)+pb(0)
        print *,' p1(0)+p2(0)+p3(0)=',p1(0)+p2(0)+p3(0)
        STOP
      ENDIF

c ----- check s12,s23 -----

      quasizero = (abs(pa(0))+abs(pb(0)))*1.d-5
      a = (p1(0)+p2(0))**2
     &  - (p1(1)+p2(1))**2 - (p1(2)+p2(2))**2 - (p1(3)+p2(3))**2
      b = (p2(0)+p3(0))**2
     &  - (p2(1)+p3(1))**2 - (p2(2)+p3(2))**2 - (p2(3)+p3(3))**2
      IF(abs(a-s12).gt.quasizero .or. abs(b-s23).gt.quasizero) THEN
        print *,' ...sub. KINEMA3 kinematics is bad'
        print *,' s12_calc,s12=',a,s12
        print *,' s23_calc,s23=',b,s23
        STOP
      ENDIF
        
c ----- theta and fi angles of the 1-particle = teta1,fi1 -----
      quasizero=1.d-5
      CALL ppp2tetafi(p1(1),p1(2),p1(3),p_tmp,teta_tmp,fi_tmp)
      IF( abs(teta1-teta_tmp).gt.quasizero ) THEN
        print *,' ...sub. KINEMA3 kinematics is bad'
        print *,' teta1,fi1==',teta1,fi1
        print *,' teta_tmp,fi_tmp==',teta_tmp,fi_tmp
        STOP
      ENDIF
c --- sckip fi1 check if teta~(0 or pii), since fi1 is undefined ---
      quasizero2=0.01
      IF(abs(teta1).gt.quasizero2.and.abs(teta1-pii).gt.quasizero)THEN
      IF( abs(fi1-fi_tmp).gt.quasizero ) THEN
        print *,' ...sub. KINEMA3 kinematics is bad'
        print *,' teta1,fi1==',teta1,fi1
        print *,' teta_tmp,fi_tmp==',teta_tmp,fi_tmp
        STOP
      ENDIF
      ENDIF


c ----- check fi23 angle -----

c      mu   - vector with the coordinates (0,0,-1)   
c      alfa - vector in the (p1,mu)-plane, which is perpendicular
c             to the p1 and situated on the mu side
c      beta - vector in the (p1,p2)-plane, which is perpendicular
c             to the p1 and situated on p2 side
c      the angles between Alfa and Beta will give us the fi23 
      
c --- skip fi23 check if teta~(0 or pii), since fi23 is undefined ---
      quasizero=1.d-5
      quasizero2=0.01
      IF(abs(teta1).gt.quasizero2.and.abs(teta1-pii).gt.quasizero2)THEN
      
      mu(1)= 0.
      mu(2)= 0.
      mu(3)=-1.
      p_tmp=sqrt( p1(1)**2 + p1(2)**2 + p1(3)**2 )
      p1_nrm(1)=p1(1)/p_tmp
      p1_nrm(2)=p1(2)/p_tmp
      p1_nrm(3)=p1(3)/p_tmp
      p_tmp=sqrt( p2(1)**2 + p2(2)**2 + p2(3)**2 )
      p2_nrm(1)=p2(1)/p_tmp
      p2_nrm(2)=p2(2)/p_tmp
      p2_nrm(3)=p2(3)/p_tmp
      mup1= p1_nrm(1)*mu(1)+p1_nrm(2)*mu(2)+p1_nrm(3)*mu(3)

c --- skip fi23 check if p2's direction is equal to the p3's one ---
      IF(abs(mup1-1.d+0).lt.quasizero) THEN  
      
      IF(abs(1.-mup1**2).lt.quasizero) THEN
        a=1.d+0
        b=0.d+0
      ELSE
        a = sqrt(1./(1.-mup1**2))
        b = -(mup1*a)
      ENDIF
      alfa(1) = ( a*mu(1) + b*p1_nrm(1) )
      alfa(2) = ( a*mu(2) + b*p1_nrm(2) )
      alfa(3) = ( a*mu(3) + b*p1_nrm(3) )
      p1p2=p1_nrm(1)*p2_nrm(1)+p1_nrm(2)*p2_nrm(2)+p1_nrm(3)*p2_nrm(3)
      IF(abs(1.-p1p2**2).lt.quasizero) THEN
        a=1.d+0
        b=0.d+0
      ELSE
        a = sqrt(1./(1.-p1p2**2))
        b = -(p1p2*a)
      ENDIF
      beta(1) = ( a*p2_nrm(1) + b*p1_nrm(1) )
      beta(2) = ( a*p2_nrm(2) + b*p1_nrm(2) )
      beta(3) = ( a*p2_nrm(3) + b*p1_nrm(3) )

c      IF(abs(fi1).lt.1.d-10) THEN
c      print *,' p1=',p1(1),p1(2),p1(3)
c      print *,' p2=',p2(1),p2(2),p2(3)
c      print *,' p3=',p3(1),p3(2),p3(3)
c      print *,' p1_nrm=',p1_nrm
c      print *,' p2_nrm=',p2_nrm
c      print *,' alfa=',alfa
c      print *,' beta=',beta
c      ENDIF
      
      a=alfa(1)*beta(1)+alfa(2)*beta(2)+alfa(3)*beta(3)
      IF(a.gt.1.d+0)  a=1.d+0
      IF(a.lt.-1.d+0) a=-1.d+0
      fi_tmp=acos(a)
      
      abv(1) = (alfa(2)*beta(3)-alfa(3)*beta(2)) * p1_nrm(1)
      abv(2) = (alfa(3)*beta(1)-alfa(1)*beta(3)) * p1_nrm(2)
      abv(3) = (alfa(1)*beta(2)-alfa(2)*beta(1)) * p1_nrm(3)
      IF( (abs(abv(1)).gt.quasizero.and.abv(1).lt.zero) .or. 
     &    (abs(abv(2)).gt.quasizero.and.abv(2).lt.zero) .or.
     &    (abs(abv(3)).gt.quasizero.and.abv(3).lt.zero)     ) THEN
        fi_tmp=2.*pii - fi_tmp
      ENDIF
            
      quasizero=1.d-4
      IF(abs(fi23-fi_tmp) .gt. quasizero ) THEN!.and.
      !&   abs(abs(fi23-fi_tmp)-2.*pii) .gt. quasizero ) THEN
        print *,' ...sub. KINEMA3 kinematics is bad'
        print *,' teta1==',teta1
        print *,' fi1==',fi1
        print *,' fi23,fi_tmp==',fi23,fi_tmp       
        STOP
      ENDIF
      
      ENDIF !(p2 along p3 or -p3 )
      ENDIF !(teta1 ~0 or pi )
      
      ENDIF !(ncheck.eq.0)


      RETURN
      END
      


C=======================================================================
C=========================== PPP2TETAFI ================================
C=========================== PPP2TETAFIR4 ==============================

c-----------------------------------------------------------------------
c    The PPP2TETAFI subroutine calculates the modulus, teta and fi
c  angles from the given Px,Py,Pz projections of a vector P.
c    The TETAFI2PPP subroutine calculates the Px, Py, Pz projections
c  of a vector P from the given modulus, teta and fi angles
c    The subroutine REDOTETAFI just recalculate teta and fi spherical
c  angles to make them be in the proper range and it also
c  make fi=0. if teta .eq. to 0 or pi.
c
c  Px,Py,Pz - x,y,z components of the 3-vector P.
c  pmod - modulus of the vector
c  teta - theta spherical angle of the vector direction. 
c  fi   - fi spherical angle of the vector direction.
c  for PPP2TETAFI:  px,py,pz      -- input
c                   pmod,teta,fi  -- output
c  for TETAFI2PPP:  px,py,pz      -- output
c                   pmod,teta,fi  -- input
c  for REDOTETAFI:  teta,fi       -- input/output
c
c  All parameters are REAL*8.
c  
c-----------------------------------------------------------------------

      SUBROUTINE ppp2tetafi(px,py,pz, pmod,teta,fi)
      IMPLICIT none
      REAL*8 px,py,pz, pmod,teta,fi
      REAL*8 piiii,zero

      zero = -1.D+0
      piiii = acos(zero)
      zero = 0.D+0      
      pmod = sqrt( px**2+py**2+pz**2 )
      IF(pmod .eq. zero) THEN           ! null vector (pmod .eq. 0)
        teta = zero
        fi = zero
      ELSE                              ! non-zero vector (pmod .ne. 0)
        teta = acos( pz / pmod )
        IF    (px.eq.zero) THEN              ! px = 0
          IF    (py.gt.zero) THEN 
            fi = piiii/2.
          ELSEIF(py.lt.zero) THEN
            fi = 3.*piiii/2.
          ELSE
            fi = zero
          ENDIF
        ELSE                                 ! px != 0
          fi = atan( py/px )
          IF( px .lt. zero ) fi = piiii + fi
          IF( fi .lt. zero ) fi = 2.*piiii + fi
        ENDIF
      ENDIF

   
      RETURN
      ENTRY tetafi2ppp(px,py,pz, pmod,teta,fi)
      
      px = pmod*cos(fi)*sin(teta)
      py = pmod*sin(fi)*sin(teta)
      pz = pmod*cos(teta)
      
      RETURN
      END


    
